/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog;

import com.jfrog.tasks.GenerateDepTrees;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class GradleDepTree
implements Plugin<Project> {
    public void apply(@Nonnull Project project) {
        boolean isCurationMode = Boolean.parseBoolean(System.getProperty("com.jfrog.curationAuditMode", "false"));
        if (isCurationMode) {
            for (Project proj : project.getAllprojects()) {
                this.configureCurationRepositories(proj);
            }
        }
        for (Project proj : project.getAllprojects()) {
            proj.getTasks().maybeCreate("generateDepTrees", GenerateDepTrees.class);
        }
    }

    private void configureCurationRepositories(Project project) {
        this.updateRepositoryUrls(project.getRepositories());
        if (project.getBuildscript().getRepositories() != null) {
            this.updateRepositoryUrls(project.getBuildscript().getRepositories());
        }
    }

    private void updateRepositoryUrls(RepositoryHandler repositories) {
        repositories.all(repo -> {
            MavenArtifactRepository mavenRepo;
            String currentUrl;
            if (repo instanceof MavenArtifactRepository && (currentUrl = (mavenRepo = (MavenArtifactRepository)repo).getUrl().toString()).contains("/artifactory/") && !currentUrl.contains("/api/curation/audit")) {
                String updatedUrl = currentUrl.replace("/artifactory/", "/artifactory/api/curation/audit/");
                mavenRepo.setUrl((Object)updatedUrl);
            }
        });
    }
}

