/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.listener;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.PublishingExtension;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.GradleClientLogger;
import org.jfrog.gradle.plugin.artifactory.utils.PluginUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public class ProjectsEvaluatedBuildListener {
    private static final Logger log = Logging.getLogger(ProjectsEvaluatedBuildListener.class);
    private static final Log clientLog = new GradleClientLogger(log);
    private final Set<Task> detailsCollectingTasks = Collections.newSetFromMap(new ConcurrentHashMap());

    private void evaluate(ArtifactoryTask collectDeployDetailsTask) {
        log.debug("Try to evaluate {}", (Object)collectDeployDetailsTask);
        Project project = collectDeployDetailsTask.getProject();
        ArtifactoryPluginConvention extension = ExtensionsUtils.getArtifactoryExtension(project);
        if (extension == null) {
            log.debug("Can't find artifactory extension.");
            return;
        }
        ArtifactoryClientConfiguration clientConfiguration = extension.getClientConfig();
        if (clientConfiguration == null) {
            log.debug("Client configuration not defined.");
            return;
        }
        ExtensionsUtils.updateConfig(clientConfiguration, project);
        if (collectDeployDetailsTask.isCiServerBuild()) {
            this.addCiAttributesToTask(collectDeployDetailsTask, clientConfiguration);
        }
        collectDeployDetailsTask.evaluateTask();
    }

    private void addCiAttributesToTask(ArtifactoryTask collectDeployDetailsTask, ArtifactoryClientConfiguration clientConfiguration) {
        PublishingExtension publishingExtension = (PublishingExtension)collectDeployDetailsTask.getProject().getExtensions().findByName("publishing");
        String publicationsNames = clientConfiguration.publisher.getPublications();
        if (StringUtils.isNotBlank((CharSequence)publicationsNames)) {
            if (publishingExtension == null) {
                log.debug("Can't find publishing extensions that is defined for the project {}", (Object)collectDeployDetailsTask.getProject().getPath());
            } else {
                collectDeployDetailsTask.publications(publicationsNames.split(","));
            }
        } else if (ProjectUtils.hasOneOfComponents(collectDeployDetailsTask.getProject(), "java", "javaPlatform")) {
            PublicationUtils.addDefaultPublicationsOrArchiveConfigurations(collectDeployDetailsTask, publishingExtension);
        }
    }

    public void afterEvaluate(Project project) {
        StartParameter startParameter = project.getGradle().getStartParameter();
        Set tasks = project.getTasksByName("artifactoryPublish", false);
        tasks.forEach(task -> {
            if (!(task instanceof ArtifactoryTask)) {
                return;
            }
            ArtifactoryTask collectDeployDetailsTask = (ArtifactoryTask)((Object)task);
            this.detailsCollectingTasks.add((Task)collectDeployDetailsTask);
            collectDeployDetailsTask.finalizeByDeployTask(project);
            if (startParameter.isConfigureOnDemand()) {
                this.evaluate(collectDeployDetailsTask);
            }
        });
        this.addResolverIfConfigured(project);
    }

    private void addResolverIfConfigured(Project project) {
        ArtifactoryClientConfiguration.ResolverHandler resolver = PluginUtils.getResolverHandler(clientLog);
        if (resolver == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{resolver.getContextUrl(), resolver.getRepoKey()})) {
            return;
        }
        String contextUrl = StringUtils.appendIfMissing((String)resolver.getContextUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        project.getRepositories().removeIf(repo -> repo instanceof MavenArtifactRepository || repo instanceof IvyArtifactRepository);
        project.getRepositories().maven(mavenArtifactRepository -> PluginUtils.addArtifactoryResolutionRepositoryAction(mavenArtifactRepository, contextUrl, resolver));
    }

    public void projectsEvaluated(Gradle gradle) {
        Set tasks = gradle.getRootProject().getTasksByName("artifactoryPublish", false);
        this.detailsCollectingTasks.addAll(tasks);
        this.detailsCollectingTasks.forEach(task -> {
            if (task instanceof ArtifactoryTask && !((ArtifactoryTask)((Object)task)).isEvaluated()) {
                ArtifactoryTask collectDeployDetailsTask = (ArtifactoryTask)((Object)task);
                this.evaluate(collectDeployDetailsTask);
                collectDeployDetailsTask.finalizeByDeployTask(collectDeployDetailsTask.getProject());
            }
        });
    }
}

