/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor.publication;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyArtifactSet;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.extractor.publication.PublicationExtractor;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public class IvyPublicationExtractor
extends PublicationExtractor<IvyPublication> {
    public IvyPublicationExtractor(ArtifactoryTask artifactoryTask) {
        super(artifactoryTask);
    }

    @Override
    public void extractDeployDetails(IvyPublication publication) {
        Map extraInfo = publication.getDescriptor().getExtraInfo().asMap();
        File ivyFile = this.extractIvyDescriptor(publication, extraInfo);
        this.extractIvyArtifacts(ivyFile, publication, extraInfo);
    }

    @Override
    protected void addArtifactToDeployDetails(IvyPublication publication, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(this.artifactoryTask.getProject());
        if (publisher == null) {
            return;
        }
        String pattern = "ivy".equals(artifactInfo.getType()) ? publisher.getIvyPattern() : publisher.getIvyArtifactPattern();
        String gid = publication.getOrganisation();
        if (publisher.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        Map<String, String> extraTokens = artifactInfo.getExtraTokens();
        String artifactPath = IvyPatternHelper.substitute((String)pattern, (String)gid, (String)publication.getModule(), (String)publication.getRevision(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publication.getName(), extraTokens, null);
        builder.artifactPath(artifactPath);
        PublicationUtils.addArtifactInfoToDeployDetails(this.artifactoryTask, publication.getName(), builder, artifactInfo, artifactPath);
    }

    @Override
    protected String getPublicationArtifactId(IvyPublication publication) {
        return publication.getModule();
    }

    @Override
    protected boolean isApplicablePublication(Publication publication) {
        return publication instanceof IvyPublication;
    }

    private File extractIvyDescriptor(IvyPublication publication, Map<QName, String> extraInfo) {
        if (!this.isPublishIvy(this.artifactoryTask)) {
            return null;
        }
        GenerateIvyDescriptor generateIvyDescriptor = this.artifactoryTask.getProject().getTasks().withType(GenerateIvyDescriptor.class).stream().filter(generateIvyDescriptorCandidate -> Objects.equals(generateIvyDescriptorCandidate.getDescriptor(), publication.getDescriptor())).findAny().orElse(null);
        if (generateIvyDescriptor == null) {
            return null;
        }
        File ivyFile = generateIvyDescriptor.getDestination();
        if (!ivyFile.exists()) {
            return null;
        }
        this.buildAndPublishArtifactWithSignatures(ivyFile, publication, publication.getModule(), "xml", "ivy", null, extraInfo);
        return ivyFile;
    }

    private boolean isPublishIvy(ArtifactoryTask task) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(task.getProject());
        if (publisher == null) {
            return false;
        }
        Boolean publishIvy = publisher.isIvy();
        if (publishIvy == null) {
            publishIvy = task.getPublishIvy();
        }
        return publishIvy != null ? publishIvy : true;
    }

    private void extractIvyArtifacts(File ivyFile, IvyPublication publication, Map<QName, String> extraInfo) {
        IvyArtifactSet artifacts = publication.getArtifacts();
        for (IvyArtifact artifact : artifacts) {
            File file = artifact.getFile();
            if (file.equals(ivyFile)) continue;
            this.buildAndPublishArtifactWithSignatures(file, publication, artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier(), extraInfo);
        }
    }
}

