/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.jfrog.gradle.plugin.artifactory.extractor.ModuleInfoFileProducer;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.task.DeployTask;
import org.jfrog.gradle.plugin.artifactory.task.ExtractModuleTask;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtils {
    private static final Logger log = LoggerFactory.getLogger(TaskUtils.class);

    private static <T extends Task> TaskProvider<T> registerTaskInProject(String taskName, Class<T> taskClass, String taskDescription, Project project, boolean publishGroup) {
        log.debug("Configuring {} task for project (is root: {}) {}", new Object[]{taskName, ProjectUtils.isRootProject(project), project.getPath()});
        TaskProvider taskProvider = project.getTasks().register(taskName, taskClass);
        taskProvider.configure(task -> {
            task.setDescription(taskDescription);
            if (publishGroup) {
                task.setGroup("publishing");
            }
        });
        return taskProvider;
    }

    public static TaskProvider<ArtifactoryTask> addCollectDeployDetailsTask(Project project) {
        try {
            return project.getTasks().named("artifactoryPublish", ArtifactoryTask.class);
        }
        catch (UnknownTaskException e) {
            log.debug("Can't find 'artifactoryPublish' task registered at the project", (Throwable)e);
            return TaskUtils.registerTaskInProject("artifactoryPublish", ArtifactoryTask.class, "Collect artifacts to be later used to generate build-info and deploy to Artifactory.", project, true);
        }
    }

    public static void addExtractModuleInfoTask(TaskProvider<ArtifactoryTask> collectDeployDetailsTask, Project project) {
        TaskProvider<ExtractModuleTask> taskProvider = null;
        try {
            taskProvider = project.getTasks().named("extractModuleInfo", ExtractModuleTask.class);
        }
        catch (UnknownTaskException e) {
            log.debug("Can't find 'extractModuleInfo' task registered at the project", (Throwable)e);
        }
        if (taskProvider == null) {
            taskProvider = TaskUtils.registerTaskInProject("extractModuleInfo", ExtractModuleTask.class, "Extracts module information to an intermediate file.", project, false);
        }
        taskProvider.configure(extractModuleTask -> {
            extractModuleTask.getOutputs().upToDateWhen(reuseOutputs -> false);
            extractModuleTask.getModuleFile().set(project.getLayout().getBuildDirectory().file("moduleInfo.json"));
            extractModuleTask.mustRunAfter(new Object[]{project.getTasks().withType(ArtifactoryTask.class)});
        });
        TaskProvider<ExtractModuleTask> finalTaskProvider = taskProvider;
        project.getRootProject().getTasks().withType(DeployTask.class).configureEach(deployTask -> deployTask.registerModuleInfoProducer(new DefaultModuleInfoFileProducer((ArtifactoryTask)((Object)((Object)collectDeployDetailsTask.get())), (ExtractModuleTask)((Object)((Object)finalTaskProvider.get())))));
    }

    public static void addDeploymentTask(Project project) {
        try {
            project.getTasks().named("artifactoryDeploy", DeployTask.class);
            return;
        }
        catch (UnknownTaskException e) {
            log.debug("Can't find 'artifactoryDeploy' task registered at the project", (Throwable)e);
            TaskUtils.registerTaskInProject("artifactoryDeploy", DeployTask.class, "Deploys artifacts and build-info to Artifactory.", project, false);
            return;
        }
    }

    public static ArtifactoryTask findExecutedCollectionTask(Project project) {
        Set tasks = project.getTasksByName("artifactoryPublish", false);
        if (tasks.isEmpty()) {
            return null;
        }
        ArtifactoryTask artifactoryTask = (ArtifactoryTask)((Object)tasks.iterator().next());
        return artifactoryTask.getState().getDidWork() ? artifactoryTask : null;
    }

    public static List<ArtifactoryTask> getAllArtifactoryPublishTasks(Project project) {
        TaskExecutionGraph graph = project.getGradle().getTaskGraph();
        ArrayList<ArtifactoryTask> tasks = new ArrayList<ArtifactoryTask>();
        for (Task task : graph.getAllTasks()) {
            if (!(task instanceof ArtifactoryTask)) continue;
            tasks.add((ArtifactoryTask)task);
        }
        return tasks;
    }

    private static class DefaultModuleInfoFileProducer
    implements ModuleInfoFileProducer {
        private final ArtifactoryTask collectDeployDetailsTask;
        private final ExtractModuleTask extractModuleTask;

        DefaultModuleInfoFileProducer(ArtifactoryTask collectDeployDetailsTask, ExtractModuleTask extractModuleTask) {
            this.collectDeployDetailsTask = collectDeployDetailsTask;
            this.extractModuleTask = extractModuleTask;
        }

        @Override
        public boolean hasModules() {
            if (this.collectDeployDetailsTask != null && this.collectDeployDetailsTask.getProject().getState().getExecuted()) {
                return this.collectDeployDetailsTask.hasPublications();
            }
            return false;
        }

        @Override
        public FileCollection getModuleInfoFiles() {
            return this.extractModuleTask.getOutputs().getFiles();
        }
    }
}

