/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.extractor;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.npm.extractor.NpmBuildInfoExtractor;
import org.jfrog.build.extractor.npm.extractor.NpmCommand;
import org.jfrog.build.extractor.npm.types.NpmProject;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class NpmInstallCi
extends NpmCommand {
    NpmBuildInfoExtractor buildInfoExtractor;
    List<String> commandArgs;
    boolean isCiCommand;

    public NpmInstallCi(ArtifactoryManagerBuilder artifactoryManagerBuilder, String resolutionRepository, String commandArgs, Log logger, Path path, Map<String, String> env, String module, String buildName, boolean isCiCommand, String project) {
        super(artifactoryManagerBuilder, resolutionRepository, logger, path, env);
        this.buildInfoExtractor = new NpmBuildInfoExtractor(artifactoryManagerBuilder, this.npmDriver, logger, module, buildName, project);
        this.commandArgs = StringUtils.isBlank((CharSequence)commandArgs) ? new ArrayList<String>() : Arrays.asList(commandArgs.trim().split("\\s+"));
        this.isCiCommand = isCiCommand;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.resolver);
            ArtifactoryClientConfiguration.PackageManagerHandler packageManagerHandler = clientConfiguration.packageManagerHandler;
            ArtifactoryClientConfiguration.NpmHandler npmHandler = clientConfiguration.npmHandler;
            NpmInstallCi npmInstall = new NpmInstallCi(artifactoryManagerBuilder, clientConfiguration.resolver.getRepoKey(), packageManagerHandler.getArgs(), clientConfiguration.getLog(), Paths.get(packageManagerHandler.getPath() != null ? packageManagerHandler.getPath() : ".", new String[0]), clientConfiguration.getAllProperties(), packageManagerHandler.getModule(), clientConfiguration.info.getBuildName(), npmHandler.isCiCommand(), clientConfiguration.info.getProject());
            npmInstall.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BuildInfo execute() {
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            this.artifactoryManager = artifactoryManager;
            this.validatePath();
            this.validateArtifactoryVersion();
            this.validateNpmVersion();
            NpmInstallCi.validateRepoExists((ArtifactoryManager)artifactoryManager, (String)this.repo, (String)"Source repo must be specified");
            NpmProject npmProject = new NpmProject(this.commandArgs, this.repo, this.workingDir, this.isCiCommand);
            BuildInfo buildInfo = this.buildInfoExtractor.extract(npmProject);
            return buildInfo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

