/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.nuget.drivers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.executor.CommandExecutor;
import org.jfrog.build.extractor.nuget.drivers.ToolchainDriverBase;

public class NugetDriver
extends ToolchainDriverBase {
    private static final String FLAG_PREFIX = "-";

    public NugetDriver(Map<String, String> env, Path workingDirectory, Log logger) {
        super(env, workingDirectory, logger);
        this.commandExecutor = new CommandExecutor("nuget", env);
    }

    @Override
    public String globalPackagesCache() throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("global-packages");
        args.add(this.getFlagSyntax("list"));
        String output = this.runCommand(new String[]{"locals"}, args, null, this.logger);
        return output.replaceFirst("^global-packages:", "").trim();
    }

    @Override
    public String getFlagSyntax(String flagName) {
        return FLAG_PREFIX + flagName;
    }
}

