/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.nuget.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;

public class NugetProjectAssets {
    private static final long serialVersionUID = 1L;
    private int version;
    private Map<String, Map<String, TargetDependency>> targets = new LinkedHashMap<String, Map<String, TargetDependency>>();
    private Map<String, Library> libraries = new LinkedHashMap<String, Library>();
    private Project project;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, Map<String, TargetDependency>> getTargets() {
        return this.targets;
    }

    public void setTarget(Map<String, Map<String, TargetDependency>> targets) {
        this.targets = targets;
    }

    public Map<String, Library> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(Map<String, Library> libraries) {
        this.libraries = libraries;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getPackagesPath() {
        return this.project.restore.packagesPath;
    }

    public void readProjectAssets(File projectAssets) throws IOException {
        try (FileInputStream fis = new FileInputStream(projectAssets);){
            String json = this.inputStreamToString(fis);
            ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
            NugetProjectAssets assets = (NugetProjectAssets)mapper.readValue(json, NugetProjectAssets.class);
            this.setVersion(assets.getVersion());
            this.setLibraries(assets.getLibraries());
            this.setProject(assets.getProject());
            this.setTarget(assets.targets);
        }
    }

    private String inputStreamToString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    public static class Project {
        private String version;
        private Restore restore;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Restore getRestore() {
            return this.restore;
        }

        public void setRestore(Restore restore) {
            this.restore = restore;
        }

        public static class Restore {
            private String packagesPath;

            public String getPackagesPath() {
                return this.packagesPath;
            }

            public void setPackagesPath(String packagesPath) {
                this.packagesPath = packagesPath;
            }
        }
    }

    public static class Library {
        private String type;
        private String path;
        private List<String> files;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getFiles() {
            return this.files;
        }

        public void setFiles(List<String> files) {
            this.files = files;
        }

        public String getNupkgFilePath() {
            for (String file : this.files) {
                if (!file.endsWith("nupkg.sha512")) continue;
                return this.path + File.separator + file.replace(".sha512", "");
            }
            return "";
        }
    }

    public static class TargetDependency {
        private Map<String, String> dependencies = new LinkedHashMap<String, String>();

        public Map<String, String> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Map<String, String> dependencies) {
            this.dependencies = dependencies;
        }
    }
}

