/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ModuleExtractor;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPlugin;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.listener.ArtifactoryDependencyResolutionListener;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PluginUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.jfrog.gradle.plugin.artifactory.utils.TaskUtils;

public class GradleModuleExtractor
implements ModuleExtractor<Project> {
    private static final Logger log = Logging.getLogger(GradleModuleExtractor.class);

    public Module extractModule(Project project) {
        ArtifactoryTask artifactoryTask = TaskUtils.findExecutedCollectionTask(project);
        ModuleType moduleType = artifactoryTask != null ? PluginUtils.getModuleType(artifactoryTask.getModuleType()) : ModuleType.GRADLE;
        Set<GradleDeployDetails> gradleDeployDetails = this.getCollectedDeployDetails(artifactoryTask);
        return this.getModuleBuilder(project, moduleType, gradleDeployDetails).build();
    }

    private Set<GradleDeployDetails> getCollectedDeployDetails(ArtifactoryTask artifactoryTask) {
        if (artifactoryTask == null) {
            return new HashSet<GradleDeployDetails>();
        }
        return artifactoryTask.getDeployDetails();
    }

    private ModuleBuilder getModuleBuilder(Project project, ModuleType moduleType, Set<GradleDeployDetails> gradleDeployDetails) {
        String moduleId = ProjectUtils.getId(project);
        String repo = gradleDeployDetails.stream().map(GradleDeployDetails::getDeployDetails).map(DeployDetails::getTargetRepository).findAny().orElse("");
        ModuleBuilder builder = new ModuleBuilder().type(moduleType).id(moduleId).repository(repo);
        try {
            builder.dependencies(this.calculateDependencies(project, moduleId));
            ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(project);
            if (publisher == null) {
                log.warn("No publisher config found for project: " + project.getName());
                return builder;
            }
            builder.excludedArtifacts(this.calculateArtifacts(ProjectUtils.filterIncludeExcludeDetails(project, publisher, gradleDeployDetails, false)));
            builder.artifacts(this.calculateArtifacts(ProjectUtils.filterIncludeExcludeDetails(project, publisher, gradleDeployDetails, true)));
        }
        catch (Exception e) {
            log.error("Error occur during extraction: ", (Throwable)e);
        }
        return builder;
    }

    private List<Artifact> calculateArtifacts(Iterable<GradleDeployDetails> deployDetails) {
        return StreamSupport.stream(deployDetails.spliterator(), false).map(from -> {
            PublishArtifactInfo publishArtifact = from.getPublishArtifact();
            DeployDetails artifactDeployDetails = from.getDeployDetails();
            String artifactPath = artifactDeployDetails.getArtifactPath();
            return new ArtifactBuilder(artifactPath.substring(artifactPath.lastIndexOf(47) + 1)).type(BuildInfoExtractorUtils.getTypeString((String)publishArtifact.getType(), (String)publishArtifact.getClassifier(), (String)publishArtifact.getExtension())).md5(artifactDeployDetails.getMd5()).sha1(artifactDeployDetails.getSha1()).sha256(artifactDeployDetails.getSha256()).remotePath(artifactPath).build();
        }).collect(Collectors.toList());
    }

    private List<Dependency> calculateDependencies(Project project, String moduleId) throws Exception {
        ArtifactoryDependencyResolutionListener artifactoryDependencyResolutionListener = ((ArtifactoryPlugin)project.getRootProject().getPlugins().getPlugin(ArtifactoryPlugin.class)).getResolutionListener();
        Map<String, String[][]> requestedByMap = artifactoryDependencyResolutionListener.getModulesHierarchyMap().get(moduleId);
        ConfigurationContainer configurationSet = project.getConfigurations();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Configuration configuration : configurationSet) {
            if (configuration.getState() != Configuration.State.RESOLVED) {
                log.info("Artifacts for configuration '{}' were not all resolved, skipping", (Object)configuration.getName());
                continue;
            }
            Set dependencyResults = configuration.getIncoming().getResolutionResult().getAllDependencies();
            for (ResolvedArtifactResult artifact : configuration.getIncoming().artifactView(view -> view.setLenient(true)).getArtifacts()) {
                Dependency extractedDependency = this.extractDependencyFromResolvedArtifact(configuration, artifact, dependencyResults, requestedByMap, dependencies);
                if (extractedDependency == null) continue;
                dependencies.add(extractedDependency);
            }
        }
        return dependencies;
    }

    private Dependency extractDependencyFromResolvedArtifact(Configuration configuration, ResolvedArtifactResult artifact, Set<? extends DependencyResult> dependencyResults, Map<String, String[][]> requestedByMap, List<Dependency> dependencies) throws NoSuchAlgorithmException, IOException {
        File file = artifact.getFile();
        if (!file.exists()) {
            return null;
        }
        String depId = this.extractDependencyId(artifact, dependencyResults);
        Dependency existingDependency = dependencies.stream().filter(input -> input.getId().equals(depId)).findAny().orElse(null);
        if (existingDependency != null) {
            Set existingScopes = existingDependency.getScopes();
            existingScopes.add(configuration.getName());
            existingDependency.setScopes(existingScopes);
            return null;
        }
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(configuration.getName());
        DependencyBuilder dependencyBuilder = new DependencyBuilder().type(StringUtils.substringAfterLast((String)file.getName(), (String)".")).id(depId).scopes(scopes);
        if (requestedByMap != null) {
            dependencyBuilder.requestedBy(requestedByMap.get(depId));
        }
        if (file.isFile()) {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
            dependencyBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).sha256((String)checksums.get("SHA-256"));
        }
        return dependencyBuilder.build();
    }

    private String extractDependencyId(ResolvedArtifactResult artifact, Set<? extends DependencyResult> dependencyResults) {
        ComponentIdentifier identifier = artifact.getId().getComponentIdentifier();
        if (!(identifier instanceof ProjectComponentIdentifier)) {
            return identifier.getDisplayName();
        }
        ResolvedComponentResult resolvedDependencyResult = dependencyResults.stream().filter(dependencyResult -> dependencyResult instanceof ResolvedDependencyResult).map(dependencyResult -> (ResolvedDependencyResult)dependencyResult).map(ResolvedDependencyResult::getSelected).filter(dependencyResult -> dependencyResult.getId().equals(identifier)).findAny().orElse(null);
        if (resolvedDependencyResult == null) {
            log.warn("Couldn't find project '{}' inside the list of projects", (Object)identifier.getDisplayName());
            return null;
        }
        return ProjectUtils.getId(resolvedDependencyResult.getModuleVersion());
    }
}

