/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;

public class ExtensionsUtils {
    public static ArtifactoryPluginConvention getOrCreateArtifactoryExtension(Project project) {
        ArtifactoryPluginConvention con = (ArtifactoryPluginConvention)project.getExtensions().findByType(ArtifactoryPluginConvention.class);
        if (con == null) {
            con = (ArtifactoryPluginConvention)project.getExtensions().create("artifactory", ArtifactoryPluginConvention.class, new Object[]{project});
        }
        return con;
    }

    public static ArtifactoryPluginConvention getArtifactoryExtension(Project project) {
        return (ArtifactoryPluginConvention)project.getRootProject().getExtensions().findByType(ArtifactoryPluginConvention.class);
    }

    public static ArtifactoryPluginConvention getExtensionWithPublisher(Project project) {
        while (project != null) {
            ArtifactoryClientConfiguration.PublisherHandler publisher;
            ArtifactoryPluginConvention acc = (ArtifactoryPluginConvention)project.getExtensions().findByType(ArtifactoryPluginConvention.class);
            if (acc != null && (publisher = acc.getClientConfig().publisher).getContextUrl() != null && (publisher.getRepoKey() != null || publisher.getSnapshotRepoKey() != null)) {
                return acc;
            }
            project = project.getParent();
        }
        return null;
    }

    public static ArtifactoryClientConfiguration.PublisherHandler getPublisherHandler(Project project) {
        ArtifactoryPluginConvention extension = ExtensionsUtils.getExtensionWithPublisher(project);
        if (extension == null) {
            return null;
        }
        return extension.getClientConfig().publisher;
    }

    public static void updateConfig(ArtifactoryClientConfiguration configuration, Project project) {
        Properties props = new Properties();
        ExtensionsUtils.fillProperties(project, props);
        StartParameter startParameter = project.getGradle().getStartParameter();
        Map startProps = startParameter.getProjectProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)startProps));
        Properties mergedProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)props, (Log)configuration.info.getLog());
        Properties buildInfoProps = BuildInfoExtractorUtils.filterDynamicProperties((Properties)mergedProps, (Predicate)BuildInfoExtractorUtils.BUILD_INFO_PROP_PREDICATE);
        buildInfoProps = BuildInfoExtractorUtils.stripPrefixFromProperties((Properties)buildInfoProps, (String)"buildInfo.property.");
        mergedProps.putAll((Map<?, ?>)buildInfoProps);
        String prefix = "buildInfo.";
        HashSet excludeIfExist = CommonUtils.newHashSet((Object[])new String[]{prefix + "build.number", prefix + "build.name", prefix + "build.started"});
        configuration.fillFromProperties(mergedProps, (Set)excludeIfExist);
        ArtifactoryClientConfiguration.addDefaultPublisherAttributes((ArtifactoryClientConfiguration)configuration, (String)project.getRootProject().getName(), (String)"Gradle", (String)project.getGradle().getGradleVersion());
    }

    private static void fillProperties(Project project, Properties props) {
        Project parent = project.getParent();
        if (parent != null) {
            ExtensionsUtils.fillProperties(parent, props);
        }
        Map projectProperties = project.getExtensions().getExtraProperties().getProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)projectProperties));
    }
}

