/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.Maven;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.api.builder.PromotionStatusBuilder;
import org.jfrog.build.extractor.builder.BuildInfoMavenBuilder;
import org.jfrog.build.extractor.ci.Agent;
import org.jfrog.build.extractor.ci.BuildAgent;
import org.jfrog.build.extractor.ci.IssueTracker;
import org.jfrog.build.extractor.ci.Issues;
import org.jfrog.build.extractor.ci.MatrixParameter;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;

@Component(role=BuildInfoModelPropertyResolver.class)
public class BuildInfoModelPropertyResolver {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    @Requirement
    private Logger logger;

    public BuildInfoMavenBuilder resolveProperties(ExecutionEvent event, ArtifactoryClientConfiguration clientConf) {
        String agentVersion;
        Vcs vcs;
        String vcsUrl;
        String vcsRevision;
        BuildInfoMavenBuilder builder = this.resolveCoreProperties(event, clientConf).artifactoryPrincipal(clientConf.publisher.getName()).artifactoryPluginVersion(clientConf.info.getArtifactoryPluginVersion()).principal(clientConf.info.getPrincipal()).parentName(clientConf.info.getParentBuildName()).parentNumber(clientConf.info.getParentBuildNumber());
        String buildUrl = clientConf.info.getBuildUrl();
        if (StringUtils.isNotBlank((CharSequence)buildUrl)) {
            builder.url(buildUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(vcsRevision = clientConf.info.getVcsRevision()))) {
            builder.vcsRevision(vcsRevision);
        }
        if (StringUtils.isNotBlank((CharSequence)(vcsUrl = clientConf.info.getVcsUrl()))) {
            builder.vcsUrl(vcsUrl);
        }
        if (!(vcs = new Vcs(vcsUrl, vcsRevision, clientConf.info.getVcsBranch(), clientConf.info.getVcsMessage())).isEmpty()) {
            builder.vcs(Arrays.asList(vcs));
        }
        BuildAgent buildAgent = new BuildAgent("Maven", this.getMavenVersion());
        builder.buildAgent(buildAgent);
        String agentName = clientConf.info.getAgentName();
        if (StringUtils.isBlank((CharSequence)agentName)) {
            agentName = buildAgent.getName();
        }
        if (StringUtils.isBlank((CharSequence)(agentVersion = clientConf.info.getAgentVersion()))) {
            agentVersion = buildAgent.getVersion();
        }
        builder.agent(new Agent(agentName, agentVersion));
        this.attachStagingIfNeeded(clientConf, builder);
        builder.artifactoryPrincipal(clientConf.publisher.getName());
        builder.artifactoryPluginVersion(clientConf.info.getArtifactoryPluginVersion());
        String issueTrackerName = clientConf.info.issues.getIssueTrackerName();
        if (StringUtils.isNotBlank((CharSequence)issueTrackerName)) {
            Issues issues = new Issues();
            issues.setAggregateBuildIssues(clientConf.info.issues.getAggregateBuildIssues());
            issues.setAggregationBuildStatus(clientConf.info.issues.getAggregationBuildStatus());
            issues.setTracker(new IssueTracker(issueTrackerName, clientConf.info.issues.getIssueTrackerVersion()));
            Set affectedIssuesSet = clientConf.info.issues.getAffectedIssuesSet();
            if (!affectedIssuesSet.isEmpty()) {
                issues.setAffectedIssues(affectedIssuesSet);
            }
            builder.issues(issues);
        }
        for (Map.Entry runParam : clientConf.info.getRunParameters().entrySet()) {
            MatrixParameter matrixParameter = new MatrixParameter((String)runParam.getKey(), (String)runParam.getValue());
            builder.addRunParameters(matrixParameter);
        }
        return builder;
    }

    private void attachStagingIfNeeded(ArtifactoryClientConfiguration clientConf, BuildInfoMavenBuilder builder) {
        if (clientConf.info.isReleaseEnabled().booleanValue()) {
            String stagingRepository = clientConf.publisher.getRepoKey();
            String comment = clientConf.info.getReleaseComment();
            if (comment == null) {
                comment = "";
            }
            Date buildStartDate = this.getBuildStartedDate(clientConf.info.getBuildStarted());
            builder.addStatus(new PromotionStatusBuilder("Staged").timestampDate(buildStartDate).comment(comment).repository(stagingRepository).ciUser(clientConf.info.getPrincipal()).user(clientConf.publisher.getUsername()).build());
        }
    }

    private BuildInfoMavenBuilder resolveCoreProperties(ExecutionEvent event, ArtifactoryClientConfiguration clientConf) {
        String buildNumber;
        String buildName = clientConf.info.getBuildName();
        if (StringUtils.isBlank((CharSequence)buildName)) {
            buildName = event.getSession().getTopLevelProject().getName();
        }
        if (StringUtils.isBlank((CharSequence)(buildNumber = clientConf.info.getBuildNumber()))) {
            buildNumber = Long.toString(System.currentTimeMillis());
        }
        String project = clientConf.info.getProject();
        Date buildStartedDate = event.getSession().getRequest().getStartTime();
        String buildStarted = clientConf.info.getBuildStarted();
        if (StringUtils.isBlank((CharSequence)buildStarted)) {
            buildStarted = DATE_FORMAT.format(buildStartedDate);
        }
        long buildMillis = this.getBuildStartedDate(buildStarted).getTime();
        String buildTimestamp = clientConf.info.getBuildTimestamp();
        if (StringUtils.isBlank((CharSequence)buildTimestamp)) {
            buildTimestamp = Long.toString(buildStartedDate.getTime());
        }
        this.logResolvedProperty("build.name", buildName);
        this.logResolvedProperty("build.number", buildNumber);
        this.logResolvedProperty("build.project", project);
        this.logResolvedProperty("build.started", buildStarted);
        this.logResolvedProperty("build.timestamp", buildTimestamp);
        return new BuildInfoMavenBuilder(buildName).number(buildNumber).project(project).started(buildStarted).startedMillis(buildMillis);
    }

    private Date getBuildStartedDate(String buildStartedIso) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("BuildInfo start date format error: " + buildStartedIso, e);
        }
    }

    private String getMavenVersion() {
        Properties mavenVersionProperties = new Properties();
        InputStream inputStream = BuildInfoRecorder.class.getClassLoader().getResourceAsStream("org/apache/maven/messages/build.properties");
        if (inputStream == null) {
            inputStream = Maven.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
        }
        if (inputStream == null) {
            throw new RuntimeException("Could not extract Maven version: unable to find resources 'org/apache/maven/messages/build.properties' or 'META-INF/maven/org.apache.maven/maven-core/pom.properties'");
        }
        try {
            mavenVersionProperties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while extracting Maven version properties from: org/apache/maven/messages/build.properties", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String version = mavenVersionProperties.getProperty("version");
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new RuntimeException("Could not extract Maven version: no version property found in the resource 'org/apache/maven/messages/build.properties'");
        }
        return version;
    }

    private void logResolvedProperty(String key, String value) {
        this.logger.debug("Artifactory Build Info Model Property Resolver: " + key + " = " + value);
    }
}

