/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import io.jenkins.plugins.jfrog.callables.JFrogCliDownloader;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.configuration.JenkinsProxyConfiguration;
import java.io.IOException;

public abstract class BinaryInstaller
extends ToolInstaller {
    protected BinaryInstaller(String label) {
        super(label);
    }

    protected FilePath getToolLocation(ToolInstallation tool, Node node) throws IOException, InterruptedException {
        FilePath location = this.preferredLocation(tool, node);
        if (!location.exists()) {
            location.mkdirs();
        }
        return location;
    }

    public static FilePath performJfrogCliInstallation(FilePath toolLocation, TaskListener log, String version, JFrogPlatformInstance instance, String repository, String binaryName) throws IOException, InterruptedException {
        JenkinsProxyConfiguration proxyConfiguration = new JenkinsProxyConfiguration();
        toolLocation.act((FilePath.FileCallable)new JFrogCliDownloader(proxyConfiguration, version, instance, log, repository, binaryName));
        return toolLocation;
    }

    public static abstract class DescriptorImpl<T extends BinaryInstaller>
    extends ToolInstallerDescriptor<T> {
        public String getId() {
            return this.clazz.getName().replace('$', '.');
        }
    }
}

