/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.EnvVars;
import io.jenkins.plugins.jfrog.actions.JFrogCliConfigEncryption;
import io.jenkins.plugins.jfrog.configuration.JenkinsProxyConfiguration;
import org.apache.commons.lang3.StringUtils;

public class CliEnvConfigurator {
    static final String JFROG_CLI_DEFAULT_EXCLUSIONS = "*password*;*psw*;*secret*;*key*;*token*;*auth*";
    static final String JFROG_CLI_ENCRYPTION_KEY = "JFROG_CLI_ENCRYPTION_KEY";
    static final String JFROG_CLI_BUILD_NUMBER = "JFROG_CLI_BUILD_NUMBER";
    public static final String JFROG_CLI_HOME_DIR = "JFROG_CLI_HOME_DIR";
    static final String JFROG_CLI_ENV_EXCLUDE = "JFROG_CLI_ENV_EXCLUDE";
    static final String JFROG_CLI_BUILD_NAME = "JFROG_CLI_BUILD_NAME";
    static final String JFROG_CLI_BUILD_URL = "JFROG_CLI_BUILD_URL";
    static final String HTTPS_PROXY_ENV = "HTTPS_PROXY";
    static final String HTTP_PROXY_ENV = "HTTP_PROXY";
    static final String NO_PROXY = "NO_PROXY";

    static void configureCliEnv(EnvVars env, String jfrogHomeTempDir, JFrogCliConfigEncryption encryptionKey) {
        env.putIfAbsent((Object)JFROG_CLI_BUILD_NAME, (Object)((String)env.get((Object)"JOB_NAME")));
        env.putIfAbsent((Object)JFROG_CLI_BUILD_NUMBER, (Object)((String)env.get((Object)"BUILD_NUMBER")));
        env.putIfAbsent((Object)JFROG_CLI_BUILD_URL, (Object)((String)env.get((Object)"BUILD_URL")));
        env.put(JFROG_CLI_HOME_DIR, jfrogHomeTempDir);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{(CharSequence)env.get((Object)HTTP_PROXY_ENV), (CharSequence)env.get((Object)HTTPS_PROXY_ENV)})) {
            CliEnvConfigurator.setupProxy(env);
        }
        if (encryptionKey.shouldEncrypt()) {
            env.putIfAbsent((Object)JFROG_CLI_ENCRYPTION_KEY, (Object)encryptionKey.getKey());
        }
    }

    private static void setupProxy(EnvVars env) {
        Object proxyUrl;
        JenkinsProxyConfiguration proxyConfiguration = new JenkinsProxyConfiguration();
        if (!proxyConfiguration.isProxyConfigured()) {
            return;
        }
        Object object = proxyUrl = proxyConfiguration.port == 443 ? "https://" : "http://";
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{proxyConfiguration.username, proxyConfiguration.password})) {
            proxyUrl = (String)proxyUrl + proxyConfiguration.username + ":" + proxyConfiguration.password + "@";
            CliEnvConfigurator.excludeProxyEnvFromPublishing(env);
        }
        proxyUrl = (String)proxyUrl + proxyConfiguration.host + ":" + proxyConfiguration.port;
        env.put(HTTP_PROXY_ENV, (String)proxyUrl);
        env.put(HTTPS_PROXY_ENV, (String)proxyUrl);
        if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.noProxy)) {
            env.put(NO_PROXY, CliEnvConfigurator.createNoProxyValue(proxyConfiguration.noProxy));
        }
    }

    private static void excludeProxyEnvFromPublishing(EnvVars env) {
        String jfrogCliEnvExclude = (String)env.getOrDefault((Object)JFROG_CLI_ENV_EXCLUDE, (Object)JFROG_CLI_DEFAULT_EXCLUSIONS);
        env.put(JFROG_CLI_ENV_EXCLUDE, String.join((CharSequence)";", jfrogCliEnvExclude, HTTP_PROXY_ENV, HTTPS_PROXY_ENV));
    }

    static String createNoProxyValue(String noProxy) {
        String noProxyListRemoveSpaceAndPipe = noProxy.trim().replaceAll("[\\s|;]+", ",");
        return noProxyListRemoveSpaceAndPipe.replaceAll(",+", ",").replaceAll("^,|,$", "");
    }
}

