/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.FilePath;
import hudson.model.Job;
import hudson.model.TaskListener;
import io.jenkins.plugins.jfrog.callables.TempDirCreator;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Utils {
    public static final String BINARY_NAME = "jf";

    public static FilePath getWorkspace(Job<?, ?> project) {
        FilePath projectJob = new FilePath(project.getRootDir());
        FilePath workspace = projectJob.getParent();
        if (workspace == null) {
            throw new RuntimeException("Failed to get job workspace.");
        }
        if ((workspace = workspace.sibling("workspace")) == null) {
            throw new RuntimeException("Failed to get job workspace.");
        }
        return workspace.child(project.getName());
    }

    public static String getJfrogCliBinaryName(boolean isWindows) {
        if (isWindows) {
            return "jf.exe";
        }
        return BINARY_NAME;
    }

    public static void deleteBuildJfrogHomeDir(FilePath ws, String buildNumber, TaskListener taskListener) {
        try {
            FilePath jfrogCliHomeDir = Utils.createAndGetJfrogCliHomeTempDir(ws, buildNumber);
            jfrogCliHomeDir.deleteRecursive();
        }
        catch (IOException | InterruptedException e) {
            taskListener.getLogger().println("Failed while attempting to delete the JFrog CLI home dir \n" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public static FilePath createAndGetTempDir(FilePath ws) throws IOException, InterruptedException {
        String workspaceList = System.getProperty("hudson.slaves.WorkspaceList");
        return (FilePath)ws.act((FilePath.FileCallable)new TempDirCreator(workspaceList, ws));
    }

    public static FilePath createAndGetJfrogCliHomeTempDir(FilePath ws, String buildNumber) throws IOException, InterruptedException {
        return Utils.createAndGetTempDir(ws).child(buildNumber).child(".jfrog");
    }
}

