/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.jfrog.Utils;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class WorkflowListener
extends FlowExecutionListener {
    public void onCompleted(@NonNull FlowExecution execution) {
        try {
            WorkflowRun build = this.getWorkflowRun(execution);
            Utils.deleteBuildJfrogHomeDir(Utils.getWorkspace(build.getParent()), String.valueOf(build.getNumber()), this.getTaskListener(execution));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TaskListener getTaskListener(FlowExecution execution) throws IOException {
        return execution.getOwner().getListener();
    }

    private WorkflowRun getWorkflowRun(FlowExecution execution) throws IOException {
        return (WorkflowRun)execution.getOwner().getExecutable();
    }
}

