/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.callables;

import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import io.jenkins.plugins.jfrog.JenkinsBuildInfoLog;
import io.jenkins.plugins.jfrog.OsUtils;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.configuration.JenkinsProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class JFrogCliDownloader
extends MasterToSlaveFileCallable<Void> {
    private static final String SHA256_FILE_NAME = "sha256";
    private static final String RELEASE = "[RELEASE]";
    JenkinsProxyConfiguration proxyConfiguration;
    private String providedVersion;
    JFrogPlatformInstance instance;
    private TaskListener log;
    String repository;
    String binaryName;

    public Void invoke(File toolLocation, VirtualChannel channel) throws IOException, InterruptedException {
        String version = (String)StringUtils.defaultIfBlank((CharSequence)this.providedVersion, (CharSequence)RELEASE);
        String cliUrlSuffix = String.format("/%s/v2-jf/%s/jfrog-cli-%s/%s", this.repository, version, OsUtils.getOsDetails(), this.binaryName);
        JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(this.log);
        String artifactoryUrl = this.instance.inferArtifactoryUrl();
        try (ArtifactoryManager manager = new ArtifactoryManager(artifactoryUrl, Secret.toString((Secret)this.instance.getCredentialsConfig().getUsername()), Secret.toString((Secret)this.instance.getCredentialsConfig().getPassword()), Secret.toString((Secret)this.instance.getCredentialsConfig().getAccessToken()), (Log)buildInfoLog);){
            String artifactorySha256;
            if (this.proxyConfiguration.isProxyConfigured(artifactoryUrl)) {
                manager.setProxyConfiguration((ProxyConfiguration)this.proxyConfiguration);
            }
            if (JFrogCliDownloader.shouldDownloadTool(toolLocation, artifactorySha256 = JFrogCliDownloader.getArtifactSha256(manager, cliUrlSuffix))) {
                if (version.equals(RELEASE)) {
                    this.log.getLogger().printf("Download '%s' latest version from: %s%n", this.binaryName, artifactoryUrl + cliUrlSuffix);
                } else {
                    this.log.getLogger().printf("Download '%s' version %s from: %s%n", this.binaryName, version, artifactoryUrl + cliUrlSuffix);
                }
                File downloadResponse = manager.downloadToFile(cliUrlSuffix, new File(toolLocation, this.binaryName).getPath());
                if (!downloadResponse.setExecutable(true)) {
                    throw new IOException("No permission to add execution permission to binary");
                }
                JFrogCliDownloader.createSha256File(toolLocation, artifactorySha256);
            }
        }
        return null;
    }

    private static void createSha256File(File toolLocation, String artifactorySha256) throws IOException {
        File file = new File(toolLocation, SHA256_FILE_NAME);
        Files.write(file.toPath(), artifactorySha256.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static boolean shouldDownloadTool(File toolLocation, String artifactorySha256) throws IOException {
        if (artifactorySha256.isEmpty()) {
            return true;
        }
        Path path = toolLocation.toPath().resolve(SHA256_FILE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        String fileContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return !StringUtils.equals((CharSequence)fileContent, (CharSequence)artifactorySha256);
    }

    private static String getArtifactSha256(ArtifactoryManager manager, String cliUrlSuffix) throws IOException {
        Header[] headers;
        for (Header header : headers = manager.downloadHeaders(cliUrlSuffix)) {
            if (!header.getName().equalsIgnoreCase("X-Checksum-Sha256")) continue;
            return header.getValue();
        }
        return "";
    }

    public JFrogCliDownloader(JenkinsProxyConfiguration proxyConfiguration, String providedVersion, JFrogPlatformInstance instance, TaskListener log, String repository, String binaryName) {
        this.proxyConfiguration = proxyConfiguration;
        this.providedVersion = providedVersion;
        this.instance = instance;
        this.log = log;
        this.repository = repository;
        this.binaryName = binaryName;
    }
}

