/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;

public class ProjectUtils {
    public static boolean isRootProject(Project project) {
        return project.equals(project.getRootProject());
    }

    public static String getId(Project project) {
        return ProjectUtils.getAsGavString(project.getGroup().toString(), project.getName(), project.getVersion().toString());
    }

    public static String getId(ModuleVersionIdentifier module) {
        if (module == null) {
            return null;
        }
        return ProjectUtils.getAsGavString(module.getGroup(), module.getName(), module.getVersion());
    }

    private static String getAsGavString(String group, String name, String version) {
        return group + ':' + name + ':' + version;
    }

    public static boolean hasOneOfComponents(Project project, String ... componentNames) {
        for (String componentName : componentNames) {
            if (project.getComponents().findByName(componentName) == null) continue;
            return true;
        }
        return false;
    }

    public static Iterable<GradleDeployDetails> filterIncludeExcludeDetails(Project project, ArtifactoryClientConfiguration.PublisherHandler publisher, Set<GradleDeployDetails> gradleDeployDetails, boolean isInclude) {
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
        if (publisher.isFilterExcludedArtifactsFromBuild()) {
            return gradleDeployDetails.stream().filter(new IncludeExcludePredicate(project, patterns, isInclude)).collect(Collectors.toSet());
        }
        if (!isInclude) {
            return new ArrayList<GradleDeployDetails>();
        }
        return gradleDeployDetails.stream().filter(new ProjectPredicate(project)).collect(Collectors.toSet());
    }

    public static class IncludeExcludePredicate
    implements Predicate<GradleDeployDetails> {
        private final Project project;
        private final IncludeExcludePatterns patterns;
        private final boolean include;

        public IncludeExcludePredicate(Project project, IncludeExcludePatterns patterns, boolean include) {
            this.project = project;
            this.patterns = patterns;
            this.include = include;
        }

        @Override
        public boolean test(@Nullable GradleDeployDetails input) {
            if (input == null || !Objects.equals(input.getProject(), this.project)) {
                return false;
            }
            if (this.include) {
                return !PatternMatcher.pathConflicts((String)input.getDeployDetails().getArtifactPath(), (IncludeExcludePatterns)this.patterns);
            }
            return PatternMatcher.pathConflicts((String)input.getDeployDetails().getArtifactPath(), (IncludeExcludePatterns)this.patterns);
        }
    }

    public static class ProjectPredicate
    implements Predicate<GradleDeployDetails> {
        private final Project project;

        private ProjectPredicate(Project project) {
            this.project = project;
        }

        @Override
        public boolean test(@Nullable GradleDeployDetails input) {
            if (input == null) {
                return false;
            }
            return input.getProject().equals(this.project);
        }
    }
}

